/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics;

import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.math.Rect;
import icyllis.modernui.platform.RenderCore;
import icyllis.modernui.platform.Window;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageAMDCallback;
import org.lwjgl.opengl.GLDebugMessageAMDCallbackI;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.APIUtil;

public final class GLWrapper
extends GL43C {
    public static final int INVALID_ID = -1;
    public static final int DEFAULT_FRAMEBUFFER = 0;
    private static boolean sInitialized = false;
    private static Redirector sRedirector;
    private static int sMaxTextureSize;
    private static int sMaxRenderBufferSize;
    private static boolean sCullState;
    private static int sCullMode;
    private static int sDrawFramebuffer;
    private static int sReadFramebuffer;
    private static final Deque<Rect> sViewportStack;
    private static int sActiveTexture;
    private static final Int2IntMap[] sBindTextures;

    private GLWrapper() {
        throw new UnsupportedOperationException();
    }

    public static synchronized void setRedirector(@Nonnull Redirector redirector) {
        if (sRedirector == null) {
            sRedirector = redirector;
        }
    }

    @RenderThread
    public static void initialize(@Nonnull GLCapabilities caps) {
        GLDebugMessageCallback proc;
        RenderCore.ensureRenderThread();
        if (sInitialized) {
            return;
        }
        if (caps.OpenGL43) {
            ModernUI.LOGGER.debug(RenderCore.MARKER, "Using OpenGL 4.3 for error logging");
            proc = GLDebugMessageCallback.create((source, type, id, severity, length, message, userParam) -> ModernUI.LOGGER.info("OpenGL debug message: {}\nSource: {}\nType: {}\nSeverity: {}\nMessage: {}", (Object)GLWrapper.getDebugId(id), (Object)GLWrapper.getDebugSource(source), (Object)GLWrapper.getDebugType(type), (Object)GLWrapper.getDebugSeverity(severity), (Object)GLDebugMessageCallback.getMessage((int)length, (long)message)));
            GLWrapper.glDebugMessageCallback((GLDebugMessageCallbackI)proc, (long)0L);
            GLWrapper.glEnable((int)37600);
        } else if (caps.GL_KHR_debug) {
            ModernUI.LOGGER.debug(RenderCore.MARKER, "Using KHR_debug for error logging");
            proc = GLDebugMessageCallback.create((source, type, id, severity, length, message, userParam) -> ModernUI.LOGGER.info("OpenGL debug message: {}\nSource: {}\nType: {}\nSeverity: {}\nMessage: {}", (Object)GLWrapper.getDebugId(id), (Object)GLWrapper.getDebugSource(source), (Object)GLWrapper.getDebugType(type), (Object)GLWrapper.getDebugSeverity(severity), (Object)GLDebugMessageCallback.getMessage((int)length, (long)message)));
            KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)proc, (long)0L);
            GLWrapper.glEnable((int)37600);
        } else if (caps.GL_ARB_debug_output) {
            ModernUI.LOGGER.debug(RenderCore.MARKER, "Using ARB_debug_output for error logging");
            proc = GLDebugMessageARBCallback.create((source, type, id, severity, length, message, userParam) -> ModernUI.LOGGER.info("OpenGL debug message: {}\nSource: {}\nType: {}\nSeverity: {}\nMessage: {}", (Object)GLWrapper.getDebugId(id), (Object)GLWrapper.getSourceARB(source), (Object)GLWrapper.getTypeARB(type), (Object)GLWrapper.getSeverityARB(severity), (Object)GLDebugMessageARBCallback.getMessage((int)length, (long)message)));
            ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)proc, (long)0L);
        } else if (caps.GL_AMD_debug_output) {
            ModernUI.LOGGER.debug(RenderCore.MARKER, "Using AMD_debug_output for error logging");
            proc = GLDebugMessageAMDCallback.create((id, category, severity, length, message, userParam) -> ModernUI.LOGGER.info("OpenGL debug message: {}\nSource: {}\nSeverity: {}\nMessage: {}", (Object)GLWrapper.getDebugId(id), (Object)GLWrapper.getCategoryAMD(category), (Object)GLWrapper.getSeverityAMD(severity), (Object)GLDebugMessageAMDCallback.getMessage((int)length, (long)message)));
            AMDDebugOutput.glDebugMessageCallbackAMD((GLDebugMessageAMDCallbackI)proc, (long)0L);
        }
        sMaxTextureSize = GLWrapper.glGetInteger((int)3379);
        sMaxRenderBufferSize = GLWrapper.glGetInteger((int)34024);
        if (!caps.OpenGL43) {
            String glVersion = GLWrapper.glGetString((int)7938);
            if (glVersion == null) {
                glVersion = "UNKNOWN";
            } else {
                try {
                    Matcher matcher = Pattern.compile("([0-9]+)\\\\.([0-9]+)(\\\\.([0-9]+))?(.+)?").matcher(glVersion);
                    glVersion = String.format("%s.%s", matcher.group(1), matcher.group(2));
                }
                catch (Exception matcher) {
                    // empty catch block
                }
            }
            int count = 0;
            if (!caps.GL_ARB_vertex_buffer_object) {
                ModernUI.LOGGER.fatal(RenderCore.MARKER, "ARB vertex buffer object is not supported");
                ++count;
            }
            if (!caps.GL_ARB_explicit_attrib_location) {
                ModernUI.LOGGER.fatal(RenderCore.MARKER, "ARB explicit attrib location is not supported");
                ++count;
            }
            if (!caps.GL_ARB_vertex_array_object) {
                ModernUI.LOGGER.fatal(RenderCore.MARKER, "ARB vertex array object is not supported");
                ++count;
            }
            if (!caps.GL_ARB_framebuffer_object) {
                ModernUI.LOGGER.fatal(RenderCore.MARKER, "ARB framebuffer object is not supported");
                ++count;
            }
            if (!caps.GL_ARB_uniform_buffer_object) {
                ModernUI.LOGGER.fatal(RenderCore.MARKER, "ARB uniform buffer object is not supported");
                ++count;
            }
            if (!caps.GL_ARB_separate_shader_objects) {
                ModernUI.LOGGER.fatal(RenderCore.MARKER, "ARB separate shader objects is not supported");
                ++count;
            }
            if (!caps.GL_ARB_explicit_uniform_location) {
                ModernUI.LOGGER.fatal(RenderCore.MARKER, "ARB explicit uniform location is not supported");
                ++count;
            }
            if (count > 0) {
                ModernUI.get().warnSetup("warning.modernui.old_opengl", "4.3", glVersion);
                ModernUI.LOGGER.fatal(RenderCore.MARKER, "OpenGL is too old, your version is {} but requires OpenGL 4.3", (Object)glVersion);
                ModernUI.LOGGER.fatal(RenderCore.MARKER, "There are {} GL capabilities that are not supported by your graphics environment", (Object)count);
                ModernUI.LOGGER.fatal(RenderCore.MARKER, "Try to use dedicated GPU for Java applications or upgrade your graphics card driver");
            }
        }
        if (sRedirector == null) {
            sRedirector = () -> {};
        } else {
            sRedirector.onInit();
        }
        ModernUI.LOGGER.info(RenderCore.MARKER, "Graphics API: OpenGL {}", (Object)GLWrapper.glGetString((int)7938));
        ModernUI.LOGGER.info(RenderCore.MARKER, "OpenGL Renderer: {} {}", (Object)GLWrapper.glGetString((int)7936), (Object)GLWrapper.glGetString((int)7937));
        sInitialized = true;
    }

    public static int getMaxTextureSize() {
        return sMaxTextureSize;
    }

    public static int getMaxRenderBufferSize() {
        return sMaxRenderBufferSize;
    }

    @RenderThread
    public static void reset(@Nonnull Window window) {
        RenderCore.ensureRenderThread();
        sViewportStack.clear();
        Rect viewport = new Rect(0, 0, window.getWidth(), window.getHeight());
        sViewportStack.push(viewport);
        GLWrapper.glViewport((int)0, (int)0, (int)window.getWidth(), (int)window.getHeight());
        GLWrapper.glClear((int)16640);
    }

    @RenderThread
    public static void bindFramebuffer(int framebuffer) {
        if (framebuffer != sDrawFramebuffer || framebuffer != sReadFramebuffer) {
            sDrawFramebuffer = sReadFramebuffer = framebuffer;
            GLWrapper.glBindFramebuffer((int)36160, (int)framebuffer);
        }
    }

    @RenderThread
    public static void bindDrawFramebuffer(int framebuffer) {
        if (framebuffer != sDrawFramebuffer) {
            sDrawFramebuffer = framebuffer;
            GLWrapper.glBindFramebuffer((int)36009, (int)framebuffer);
        }
    }

    @RenderThread
    public static void bindReadFramebuffer(int framebuffer) {
        if (framebuffer != sReadFramebuffer) {
            sReadFramebuffer = framebuffer;
            GLWrapper.glBindFramebuffer((int)36008, (int)framebuffer);
        }
    }

    @RenderThread
    public static void bindTexture(int target, int texture) {
        if (sRedirector.bindTexture(target, texture)) {
            return;
        }
        if (sBindTextures[sActiveTexture].put(target, texture) != texture) {
            GLWrapper.glBindTexture((int)target, (int)texture);
        }
    }

    @RenderThread
    public static void deleteTexture(int target, int texture) {
        if (sRedirector.deleteTexture(target, texture)) {
            return;
        }
        for (Int2IntMap m3 : sBindTextures) {
            m3.put(target, 0);
        }
        GLWrapper.glDeleteTextures((int)texture);
    }

    @RenderThread
    public static void activeTexture(int unit) {
        if (unit != sActiveTexture) {
            sActiveTexture = unit;
            GLWrapper.glActiveTexture((int)(33984 + unit));
        }
    }

    @RenderThread
    public static int getActiveTexture() {
        return sActiveTexture;
    }

    @RenderThread
    public static void enableCull() {
        if (!sCullState) {
            sCullState = true;
            GLWrapper.glEnable((int)2884);
        }
    }

    @RenderThread
    public static void disableCull() {
        if (sCullState) {
            sCullState = false;
            GLWrapper.glDisable((int)2884);
        }
    }

    @RenderThread
    public static void cullFace(int mode) {
        if (mode != sCullMode) {
            sCullMode = mode;
            GLWrapper.glCullFace((int)mode);
        }
    }

    @RenderThread
    public static void pushViewport(@Nonnull Rect viewport) {
        if (viewport.isEmpty()) {
            return;
        }
        Rect top = sViewportStack.peek();
        sViewportStack.push(viewport);
        if (viewport.equals(top)) {
            return;
        }
        GLWrapper.glViewport((int)viewport.left, (int)viewport.top, (int)viewport.width(), (int)viewport.height());
    }

    @RenderThread
    public static void popViewport() {
        Rect last = sViewportStack.pop();
        if (!Objects.equals(sViewportStack.peek(), last)) {
            GLWrapper.glViewport((int)last.left, (int)last.top, (int)last.width(), (int)last.height());
        }
        if (sViewportStack.isEmpty()) {
            throw new IllegalStateException("Popping the main viewport");
        }
    }

    @Nonnull
    private static String getDebugId(int id) {
        switch (id) {
            case 1280: {
                return "GL_INVALID_ENUM";
            }
            case 1281: {
                return "GL_INVALID_VALUE";
            }
            case 1282: {
                return "GL_INVALID_OPERATION";
            }
        }
        return String.format("0x%X", id);
    }

    @Nonnull
    private static String getDebugSource(int source) {
        switch (source) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "Window System";
            }
            case 33352: {
                return "Shader Compiler";
            }
            case 33353: {
                return "Third Party";
            }
            case 33354: {
                return "Application";
            }
            case 33355: {
                return "Other";
            }
        }
        return APIUtil.apiUnknownToken((int)source);
    }

    @Nonnull
    private static String getDebugType(int type) {
        switch (type) {
            case 33356: {
                return "Error";
            }
            case 33357: {
                return "Deprecated Behavior";
            }
            case 33358: {
                return "Undefined Behavior";
            }
            case 33359: {
                return "Portability";
            }
            case 33360: {
                return "Performance";
            }
            case 33361: {
                return "Other";
            }
            case 33384: {
                return "Marker";
            }
        }
        return APIUtil.apiUnknownToken((int)type);
    }

    @Nonnull
    private static String getDebugSeverity(int severity) {
        switch (severity) {
            case 37190: {
                return "High";
            }
            case 37191: {
                return "Medium";
            }
            case 37192: {
                return "Low";
            }
            case 33387: {
                return "Notification";
            }
        }
        return APIUtil.apiUnknownToken((int)severity);
    }

    @Nonnull
    private static String getSourceARB(int source) {
        switch (source) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "Window System";
            }
            case 33352: {
                return "Shader Compiler";
            }
            case 33353: {
                return "Third Party";
            }
            case 33354: {
                return "Application";
            }
            case 33355: {
                return "Other";
            }
        }
        return APIUtil.apiUnknownToken((int)source);
    }

    @Nonnull
    private static String getTypeARB(int type) {
        switch (type) {
            case 33356: {
                return "Error";
            }
            case 33357: {
                return "Deprecated Behavior";
            }
            case 33358: {
                return "Undefined Behavior";
            }
            case 33359: {
                return "Portability";
            }
            case 33360: {
                return "Performance";
            }
            case 33361: {
                return "Other";
            }
        }
        return APIUtil.apiUnknownToken((int)type);
    }

    @Nonnull
    private static String getSeverityARB(int severity) {
        switch (severity) {
            case 37190: {
                return "High";
            }
            case 37191: {
                return "Medium";
            }
            case 37192: {
                return "Low";
            }
        }
        return APIUtil.apiUnknownToken((int)severity);
    }

    @Nonnull
    private static String getCategoryAMD(int category) {
        switch (category) {
            case 37193: {
                return "API Error";
            }
            case 37194: {
                return "Window System";
            }
            case 37195: {
                return "Deprecation";
            }
            case 37196: {
                return "Undefined Behavior";
            }
            case 37197: {
                return "Performance";
            }
            case 37198: {
                return "Shader Compiler";
            }
            case 37199: {
                return "Application";
            }
            case 37200: {
                return "Other";
            }
        }
        return APIUtil.apiUnknownToken((int)category);
    }

    @Nonnull
    private static String getSeverityAMD(int severity) {
        switch (severity) {
            case 37190: {
                return "High";
            }
            case 37191: {
                return "Medium";
            }
            case 37192: {
                return "Low";
            }
        }
        return APIUtil.apiUnknownToken((int)severity);
    }

    static {
        sMaxTextureSize = 1024;
        sMaxRenderBufferSize = 2048;
        sCullState = false;
        sCullMode = 1029;
        sDrawFramebuffer = 0;
        sReadFramebuffer = 0;
        sViewportStack = new ArrayDeque<Rect>();
        sActiveTexture = 0;
        Int2IntMap[] bindTextures = new Int2IntMap[32];
        for (int i = 0; i < 32; ++i) {
            Int2IntArrayMap o = new Int2IntArrayMap();
            o.defaultReturnValue(0);
            bindTextures[i] = o;
        }
        sBindTextures = bindTextures;
    }

    @FunctionalInterface
    public static interface Redirector {
        public void onInit();

        default public boolean bindTexture(int target, int texture) {
            return false;
        }

        default public boolean deleteTexture(int target, int texture) {
            return false;
        }
    }
}

